@echo off
title backhaulWatcher
setlocal EnableDelayedExpansion
cd %~dp0
REM Try to get ConfigurationFile. If it doesn't exist, try to get the backup. Otherwise, end.
if exist ..\BackhaulConfiguration.conf (
    set configFile=..\BackhaulConfiguration.conf
    echo Using BackhaulConfiguration.conf
) else (
    if exist ..\BackhaulConfigurationBackup.conf (
        set configFile=..\BackhaulConfigurationBackup.conf
        echo Using BackhaulConfigurationBackup.conf
    ) else (
        echo "NO CONFIGURATION FILE!"
        timeout/t 30
        exit
    )
)

cd %~dp0
echo |set /p="Maximum Backup Worker Count: "
for /f "tokens=* delims=" %%a in ('jsonextractor.bat %configFile% backupWorkerCount') do (
 set "maxBackupWorkers=%%~a"
)
echo %maxBackupWorkers%

echo |set /p="Queue Length Threshold before Backup workers are generated: "
for /f "tokens=* delims=" %%a in ('jsonextractor.bat %configFile% queueLengthThreshold') do (
 set "queueLengthThreshold=%%~a"
)
echo %queueLengthThreshold%
echo |set /p="Inverval to check in seconds: "
for /f "tokens=* delims=" %%a in ('jsonextractor.bat %configFile% watcherCheckInterval') do (
 set "checkInterval=%%~a"
)
echo %checkInterval%

echo ===============================================================================
echo BACKHAUL WATCHER start
echo ===============================================================================

echo maxBackupWorkers %maxBackupWorkers%
echo queueLengthThreshold %queueLengthThreshold%
echo checkInterval %checkInterval%

set currentWorkerCount=0
set watcherTmp=%~dp0BackhaulWatcherTemp
echo %watcherTmp%

:loop 
cd %~dp0

echo |set /p="This window's Process ID: "
call getPID.bat
SET pid=%errorlevel%
cd ..
echo %pid% >> processes\%pid% 
cd %~dp0

if exist forceStop (
    EXIT
)

if exist ..\..\..\ProgramFiles\RabbitMQServer\rabbitmq_server-3.8.2\sbin\rabbitmqctl.bat (
    echo This is the server
    cd ..\..\..\ProgramFiles\RabbitMQServer\rabbitmq_server-3.8.2\sbin\
) else (
    if exist C:\Program Files\RabbitMQ Server\rabbitmq_server-3.8.3\sbin\ (
        echo PC or Mirrors
        cd C:\Program Files\RabbitMQ Server\rabbitmq_server-3.8.3\sbin\
    )
)

call rabbitmqctl list_queues | for /F "delims=" %%a in ('findstr /M /C:"publicQueue"') do (
    echo %%a > %watcherTmp%
) 
for /f "delims=" %%x in (%watcherTmp%) do set text=%%x
for /F "tokens=1* delims=:publicQueue: " %%a in ("%text%") do (
    set queueLength=%%a
)

cd %~dp0
if %queueLength% gtr %queueLengthThreshold% (
    
    if !currentWorkerCount! lss %maxBackupWorkers% (
        start /min backupSocketWorker.bat
        echo Generated a backup socket worker!
        set /a currentWorkerCount+=1
    ) else (
        echo maxBackupWorkers reached. Manually increase maxBackupWorkers if needed.
    )
) else (
    echo Public Queue Length below %queueLengthThreshold%. Able to kill off backups or no action required.
    if !currentWorkerCount! gtr 0 (
        call killSingleBackupWorker.bat
        set /a currentWorkerCount-=1
        ) else (
            echo No more backup workers!  
        )
    )   
)

@echo on
echo BackhaulWatcher completed. Waiting for next Interval...
timeout /t %checkInterval%
@echo off
GOTO :LOOP 